<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Language extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'code',
        'icon',
        'rtl',
        'status',
        'default',
        'font_id'
    ];

    public function getIconAttribute()
    {
        if ($this->fileAttach) {
            return $this->fileAttach->FileUrl;
        }
        return asset('assets/images/no-image.jpg');
    }

    public function fileAttach()
    {
        return $this->morphOne(FileManager::class, 'origin');
    }

    public function getFontAttribute()
    {
        if ($this->fileAttachFont) {
            return $this->fileAttachFont->FileUrl;
        }
        return '';
    }

    public function fileAttachFont()
    {
        return $this->hasOne(FileManager::class, 'id', 'font_id');
    }
}
