<?php
declare(strict_types=1);

/**
 * BulkProcessDataApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\BulkProcessDataApi;



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * BulkProcessDataApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BulkProcessDataApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createBulkProcessRequest
     *
     * Uses the specified bulk envelopes list to update the envelopes specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function createBulkProcessRequest($account_id, $process_action)
    {
        list($response) = $this->createBulkProcessRequestWithHttpInfo($account_id, $process_action);
        return $response;
    }

    /**
     * Operation createBulkProcessRequestWithHttpInfo
     *
     * Uses the specified bulk envelopes list to update the envelopes specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkProcessRequestWithHttpInfo($account_id, $process_action): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBulkProcessRequest');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling createBulkProcessRequest');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createBulkProcessRequestToQueue
     *
     * Uses the specified bulk envelopes list to update the envelopes specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     * @param \DocuSign\eSign\Model\BulkProcessRequest $bulk_process_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkProcessResponse
     */
    public function createBulkProcessRequestToQueue($account_id, $bulk_process_list_id, $process_action, $bulk_process_request = null)
    {
        list($response) = $this->createBulkProcessRequestToQueueWithHttpInfo($account_id, $bulk_process_list_id, $process_action, $bulk_process_request);
        return $response;
    }

    /**
     * Operation createBulkProcessRequestToQueueWithHttpInfo
     *
     * Uses the specified bulk envelopes list to update the envelopes specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     * @param \DocuSign\eSign\Model\BulkProcessRequest $bulk_process_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkProcessResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkProcessRequestToQueueWithHttpInfo($account_id, $bulk_process_list_id, $process_action, $bulk_process_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBulkProcessRequestToQueue');
        }
        // verify the required parameter 'bulk_process_list_id' is set
        if ($bulk_process_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_process_list_id when calling createBulkProcessRequestToQueue');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling createBulkProcessRequestToQueue');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_process_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkProcessListId", $bulk_process_list_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_process_request)) {
            $_tempBody = $bulk_process_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkProcessResponse',
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkProcessResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkProcessResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBulkProcessList
     *
     * Deletes a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkProcessResult
     */
    public function deleteBulkProcessList($account_id, $bulk_process_list_id, $process_action)
    {
        list($response) = $this->deleteBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action);
        return $response;
    }

    /**
     * Operation deleteBulkProcessListWithHttpInfo
     *
     * Deletes a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkProcessResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBulkProcessList');
        }
        // verify the required parameter 'bulk_process_list_id' is set
        if ($bulk_process_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_process_list_id when calling deleteBulkProcessList');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling deleteBulkProcessList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_process_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkProcessListId", $bulk_process_list_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkProcessResult',
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkProcessResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkProcessResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBulkProcessLists
     *
     * Deletes a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     * @param \DocuSign\eSign\Model\BulkProcessingLists $bulk_processing_lists  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkProcessResult
     */
    public function deleteBulkProcessLists($account_id, $process_action, $bulk_processing_lists = null)
    {
        list($response) = $this->deleteBulkProcessListsWithHttpInfo($account_id, $process_action, $bulk_processing_lists);
        return $response;
    }

    /**
     * Operation deleteBulkProcessListsWithHttpInfo
     *
     * Deletes a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     * @param \DocuSign\eSign\Model\BulkProcessingLists $bulk_processing_lists  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkProcessResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBulkProcessListsWithHttpInfo($account_id, $process_action, $bulk_processing_lists = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBulkProcessLists');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling deleteBulkProcessLists');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_processing_lists)) {
            $_tempBody = $bulk_processing_lists;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkProcessResult',
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkProcessResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkProcessResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkProcessList
     *
     * Gets a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function getBulkProcessList($account_id, $bulk_process_list_id, $process_action)
    {
        list($response) = $this->getBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action);
        return $response;
    }

    /**
     * Operation getBulkProcessListWithHttpInfo
     *
     * Gets a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkProcessList');
        }
        // verify the required parameter 'bulk_process_list_id' is set
        if ($bulk_process_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_process_list_id when calling getBulkProcessList');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling getBulkProcessList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_process_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkProcessListId", $bulk_process_list_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkProcessLists
     *
     * Lists top-level details for all bulk process lists visible to the current user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkProcessingListSummaries
     */
    public function getBulkProcessLists($account_id, $process_action)
    {
        list($response) = $this->getBulkProcessListsWithHttpInfo($account_id, $process_action);
        return $response;
    }

    /**
     * Operation getBulkProcessListsWithHttpInfo
     *
     * Lists top-level details for all bulk process lists visible to the current user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkProcessingListSummaries, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkProcessListsWithHttpInfo($account_id, $process_action): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkProcessLists');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling getBulkProcessLists');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkProcessingListSummaries',
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkProcessingListSummaries', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkProcessingListSummaries', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBulkProcessList
     *
     * Updates a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateBulkProcessList($account_id, $bulk_process_list_id, $process_action)
    {
        list($response) = $this->updateBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action);
        return $response;
    }

    /**
     * Operation updateBulkProcessListWithHttpInfo
     *
     * Updates a specific bulk process list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_process_list_id 
     * @param ?string $process_action 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkProcessListWithHttpInfo($account_id, $bulk_process_list_id, $process_action): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBulkProcessList');
        }
        // verify the required parameter 'bulk_process_list_id' is set
        if ($bulk_process_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_process_list_id when calling updateBulkProcessList');
        }
        // verify the required parameter 'process_action' is set
        if ($process_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $process_action when calling updateBulkProcessList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_process_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkProcessListId", $bulk_process_list_id);
        }
        // path params
        if ($process_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "processAction", $process_action);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
