<?php
/**
 * EnvelopePublishTransaction
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * EnvelopePublishTransaction Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EnvelopePublishTransaction implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'envelopePublishTransaction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'apply_connect_settings' => '?string',
        'envelope_count' => '?string',
        'envelope_level_error_rollups' => '\DocuSign\eSign\Model\EnvelopePublishTransactionErrorRollup[]',
        'envelope_publish_transaction_id' => '?string',
        'error_count' => '?string',
        'file_level_errors' => '?string[]',
        'no_action_required_envelope_count' => '?string',
        'processed_envelope_count' => '?string',
        'processing_status' => '?string',
        'results_uri' => '?string',
        'submission_date' => '?string',
        'submitted_by_user_info' => '\DocuSign\eSign\Model\UserInfo',
        'submitted_for_publishing_envelope_count' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'apply_connect_settings' => null,
        'envelope_count' => null,
        'envelope_level_error_rollups' => null,
        'envelope_publish_transaction_id' => null,
        'error_count' => null,
        'file_level_errors' => null,
        'no_action_required_envelope_count' => null,
        'processed_envelope_count' => null,
        'processing_status' => null,
        'results_uri' => null,
        'submission_date' => null,
        'submitted_by_user_info' => null,
        'submitted_for_publishing_envelope_count' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'apply_connect_settings' => 'applyConnectSettings',
        'envelope_count' => 'envelopeCount',
        'envelope_level_error_rollups' => 'envelopeLevelErrorRollups',
        'envelope_publish_transaction_id' => 'envelopePublishTransactionId',
        'error_count' => 'errorCount',
        'file_level_errors' => 'fileLevelErrors',
        'no_action_required_envelope_count' => 'noActionRequiredEnvelopeCount',
        'processed_envelope_count' => 'processedEnvelopeCount',
        'processing_status' => 'processingStatus',
        'results_uri' => 'resultsUri',
        'submission_date' => 'submissionDate',
        'submitted_by_user_info' => 'submittedByUserInfo',
        'submitted_for_publishing_envelope_count' => 'submittedForPublishingEnvelopeCount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'apply_connect_settings' => 'setApplyConnectSettings',
        'envelope_count' => 'setEnvelopeCount',
        'envelope_level_error_rollups' => 'setEnvelopeLevelErrorRollups',
        'envelope_publish_transaction_id' => 'setEnvelopePublishTransactionId',
        'error_count' => 'setErrorCount',
        'file_level_errors' => 'setFileLevelErrors',
        'no_action_required_envelope_count' => 'setNoActionRequiredEnvelopeCount',
        'processed_envelope_count' => 'setProcessedEnvelopeCount',
        'processing_status' => 'setProcessingStatus',
        'results_uri' => 'setResultsUri',
        'submission_date' => 'setSubmissionDate',
        'submitted_by_user_info' => 'setSubmittedByUserInfo',
        'submitted_for_publishing_envelope_count' => 'setSubmittedForPublishingEnvelopeCount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'apply_connect_settings' => 'getApplyConnectSettings',
        'envelope_count' => 'getEnvelopeCount',
        'envelope_level_error_rollups' => 'getEnvelopeLevelErrorRollups',
        'envelope_publish_transaction_id' => 'getEnvelopePublishTransactionId',
        'error_count' => 'getErrorCount',
        'file_level_errors' => 'getFileLevelErrors',
        'no_action_required_envelope_count' => 'getNoActionRequiredEnvelopeCount',
        'processed_envelope_count' => 'getProcessedEnvelopeCount',
        'processing_status' => 'getProcessingStatus',
        'results_uri' => 'getResultsUri',
        'submission_date' => 'getSubmissionDate',
        'submitted_by_user_info' => 'getSubmittedByUserInfo',
        'submitted_for_publishing_envelope_count' => 'getSubmittedForPublishingEnvelopeCount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['apply_connect_settings'] = isset($data['apply_connect_settings']) ? $data['apply_connect_settings'] : null;
        $this->container['envelope_count'] = isset($data['envelope_count']) ? $data['envelope_count'] : null;
        $this->container['envelope_level_error_rollups'] = isset($data['envelope_level_error_rollups']) ? $data['envelope_level_error_rollups'] : null;
        $this->container['envelope_publish_transaction_id'] = isset($data['envelope_publish_transaction_id']) ? $data['envelope_publish_transaction_id'] : null;
        $this->container['error_count'] = isset($data['error_count']) ? $data['error_count'] : null;
        $this->container['file_level_errors'] = isset($data['file_level_errors']) ? $data['file_level_errors'] : null;
        $this->container['no_action_required_envelope_count'] = isset($data['no_action_required_envelope_count']) ? $data['no_action_required_envelope_count'] : null;
        $this->container['processed_envelope_count'] = isset($data['processed_envelope_count']) ? $data['processed_envelope_count'] : null;
        $this->container['processing_status'] = isset($data['processing_status']) ? $data['processing_status'] : null;
        $this->container['results_uri'] = isset($data['results_uri']) ? $data['results_uri'] : null;
        $this->container['submission_date'] = isset($data['submission_date']) ? $data['submission_date'] : null;
        $this->container['submitted_by_user_info'] = isset($data['submitted_by_user_info']) ? $data['submitted_by_user_info'] : null;
        $this->container['submitted_for_publishing_envelope_count'] = isset($data['submitted_for_publishing_envelope_count']) ? $data['submitted_for_publishing_envelope_count'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets apply_connect_settings
     *
     * @return ?string
     */
    public function getApplyConnectSettings()
    {
        return $this->container['apply_connect_settings'];
    }

    /**
     * Sets apply_connect_settings
     *
     * @param ?string $apply_connect_settings 
     *
     * @return $this
     */
    public function setApplyConnectSettings($apply_connect_settings)
    {
        $this->container['apply_connect_settings'] = $apply_connect_settings;

        return $this;
    }

    /**
     * Gets envelope_count
     *
     * @return ?string
     */
    public function getEnvelopeCount()
    {
        return $this->container['envelope_count'];
    }

    /**
     * Sets envelope_count
     *
     * @param ?string $envelope_count 
     *
     * @return $this
     */
    public function setEnvelopeCount($envelope_count)
    {
        $this->container['envelope_count'] = $envelope_count;

        return $this;
    }

    /**
     * Gets envelope_level_error_rollups
     *
     * @return \DocuSign\eSign\Model\EnvelopePublishTransactionErrorRollup[]
     */
    public function getEnvelopeLevelErrorRollups()
    {
        return $this->container['envelope_level_error_rollups'];
    }

    /**
     * Sets envelope_level_error_rollups
     *
     * @param \DocuSign\eSign\Model\EnvelopePublishTransactionErrorRollup[] $envelope_level_error_rollups 
     *
     * @return $this
     */
    public function setEnvelopeLevelErrorRollups($envelope_level_error_rollups)
    {
        $this->container['envelope_level_error_rollups'] = $envelope_level_error_rollups;

        return $this;
    }

    /**
     * Gets envelope_publish_transaction_id
     *
     * @return ?string
     */
    public function getEnvelopePublishTransactionId()
    {
        return $this->container['envelope_publish_transaction_id'];
    }

    /**
     * Sets envelope_publish_transaction_id
     *
     * @param ?string $envelope_publish_transaction_id 
     *
     * @return $this
     */
    public function setEnvelopePublishTransactionId($envelope_publish_transaction_id)
    {
        $this->container['envelope_publish_transaction_id'] = $envelope_publish_transaction_id;

        return $this;
    }

    /**
     * Gets error_count
     *
     * @return ?string
     */
    public function getErrorCount()
    {
        return $this->container['error_count'];
    }

    /**
     * Sets error_count
     *
     * @param ?string $error_count 
     *
     * @return $this
     */
    public function setErrorCount($error_count)
    {
        $this->container['error_count'] = $error_count;

        return $this;
    }

    /**
     * Gets file_level_errors
     *
     * @return ?string[]
     */
    public function getFileLevelErrors()
    {
        return $this->container['file_level_errors'];
    }

    /**
     * Sets file_level_errors
     *
     * @param ?string[] $file_level_errors 
     *
     * @return $this
     */
    public function setFileLevelErrors($file_level_errors)
    {
        $this->container['file_level_errors'] = $file_level_errors;

        return $this;
    }

    /**
     * Gets no_action_required_envelope_count
     *
     * @return ?string
     */
    public function getNoActionRequiredEnvelopeCount()
    {
        return $this->container['no_action_required_envelope_count'];
    }

    /**
     * Sets no_action_required_envelope_count
     *
     * @param ?string $no_action_required_envelope_count 
     *
     * @return $this
     */
    public function setNoActionRequiredEnvelopeCount($no_action_required_envelope_count)
    {
        $this->container['no_action_required_envelope_count'] = $no_action_required_envelope_count;

        return $this;
    }

    /**
     * Gets processed_envelope_count
     *
     * @return ?string
     */
    public function getProcessedEnvelopeCount()
    {
        return $this->container['processed_envelope_count'];
    }

    /**
     * Sets processed_envelope_count
     *
     * @param ?string $processed_envelope_count 
     *
     * @return $this
     */
    public function setProcessedEnvelopeCount($processed_envelope_count)
    {
        $this->container['processed_envelope_count'] = $processed_envelope_count;

        return $this;
    }

    /**
     * Gets processing_status
     *
     * @return ?string
     */
    public function getProcessingStatus()
    {
        return $this->container['processing_status'];
    }

    /**
     * Sets processing_status
     *
     * @param ?string $processing_status 
     *
     * @return $this
     */
    public function setProcessingStatus($processing_status)
    {
        $this->container['processing_status'] = $processing_status;

        return $this;
    }

    /**
     * Gets results_uri
     *
     * @return ?string
     */
    public function getResultsUri()
    {
        return $this->container['results_uri'];
    }

    /**
     * Sets results_uri
     *
     * @param ?string $results_uri 
     *
     * @return $this
     */
    public function setResultsUri($results_uri)
    {
        $this->container['results_uri'] = $results_uri;

        return $this;
    }

    /**
     * Gets submission_date
     *
     * @return ?string
     */
    public function getSubmissionDate()
    {
        return $this->container['submission_date'];
    }

    /**
     * Sets submission_date
     *
     * @param ?string $submission_date 
     *
     * @return $this
     */
    public function setSubmissionDate($submission_date)
    {
        $this->container['submission_date'] = $submission_date;

        return $this;
    }

    /**
     * Gets submitted_by_user_info
     *
     * @return \DocuSign\eSign\Model\UserInfo
     */
    public function getSubmittedByUserInfo()
    {
        return $this->container['submitted_by_user_info'];
    }

    /**
     * Sets submitted_by_user_info
     *
     * @param \DocuSign\eSign\Model\UserInfo $submitted_by_user_info 
     *
     * @return $this
     */
    public function setSubmittedByUserInfo($submitted_by_user_info)
    {
        $this->container['submitted_by_user_info'] = $submitted_by_user_info;

        return $this;
    }

    /**
     * Gets submitted_for_publishing_envelope_count
     *
     * @return ?string
     */
    public function getSubmittedForPublishingEnvelopeCount()
    {
        return $this->container['submitted_for_publishing_envelope_count'];
    }

    /**
     * Sets submitted_for_publishing_envelope_count
     *
     * @param ?string $submitted_for_publishing_envelope_count 
     *
     * @return $this
     */
    public function setSubmittedForPublishingEnvelopeCount($submitted_for_publishing_envelope_count)
    {
        $this->container['submitted_for_publishing_envelope_count'] = $submitted_for_publishing_envelope_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

